import csv
import pandas
from typing import Iterator

from allennlp.data import Instance
from allennlp.data.fields import TextField

from config import Config
from tools.utils import create_dir_of_file
from .dataset_reader import DatasetReader


class IMDBDatasetReader(DatasetReader):
    def __init__(self, cf: Config, token_type=None):
        super(IMDBDatasetReader, self).__init__(cf, token_type, lazy=False)

    def _read(self, file_path: str) -> Iterator[Instance]:
        data = pandas.read_csv(file_path)
        X = data['review'].tolist()
        Y = data['sentiment'].tolist()
        for (x, y) in zip(X, Y):
            yield self.text_to_instance(x, y)

    def _write(self, file_path: str, data):
        create_dir_of_file(file_path)
        with open(file_path, 'w') as f:
            csv_file = csv.writer(f)
            csv_file.writerow(['review', 'sentiment'])
            for d in data:
                sentence = d['sentence']
                label = d['label']
                csv_file.writerow([sentence, label])

    def read_json(self, file_path):
        json_data = []
        data = pandas.read_csv(file_path)
        X = data['review'].tolist()
        Y = data['sentiment'].tolist()
        for (x, y) in zip(X, Y):
            json_data.append(self.text_to_json(x, y))
        return json_data
